package gov.va.vamf.scheduling.direct.datalayer.clinic;

import gov.va.vamf.scheduling.direct.domain.CdwClinic;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;

import static org.apache.commons.lang.StringUtils.*;

public class ClinicResultSetRowMapper implements RowMapper<CdwClinic> {

	private static final String LOCATION_IEN_COL = "LocationIEN";
	private static final String STA3N_COL = "Sta3n";
	private static final String LOCATION_NAME_COL = "LocationName";
	private static final String PRIMARY_STOP_CODE_COL = "PrimaryStopCode";
	private static final String SECONDARY_STOP_CODE_COL = "SecondaryStopCode";
	private static final String INSTITUTION_NAME_COL = "VAST_STA_NAME";
	private static final String INSTITUTION_CODE_COL = "STA6AID";
	private static final String FRIENDLY_LOCATION_NAME_COL = "PatientFriendlyLocationName";
	private static final String DIRECT_PATIENT_SCHED_FLAG_COL = "DirectSchedulingPatientFlag";
	private static final String DISPLAY_APPT_TO_PATIENT_FLAG_COL = "DisplayAppointmentFlag";

	@Override
	public CdwClinic mapRow(ResultSet rs, int rowNum) throws SQLException {

		CdwClinic cdwClinic = new CdwClinic();

		cdwClinic.setSiteCode(trimToEmpty(rs.getString(STA3N_COL)));
		cdwClinic.setClinicId(trimToEmpty(rs.getString(LOCATION_IEN_COL)));
		cdwClinic.setClinicName(trimToEmpty(rs.getString(LOCATION_NAME_COL)));
		cdwClinic.setPrimaryStopCode(trimToEmpty(rs.getString(PRIMARY_STOP_CODE_COL)));
		cdwClinic.setSecondaryStopCode(trimToEmpty(rs.getString(SECONDARY_STOP_CODE_COL)));
		cdwClinic.setInstitutionName(trimToEmpty(rs.getString(INSTITUTION_NAME_COL)));
		cdwClinic.setInstitutionCode(trimToEmpty(rs.getString(INSTITUTION_CODE_COL)));
		cdwClinic.setClinicFriendlyLocationName(trimToEmpty(rs.getString(FRIENDLY_LOCATION_NAME_COL)));
		cdwClinic.setDirectSchedulingFlag(trimToEmpty(rs.getString(DIRECT_PATIENT_SCHED_FLAG_COL)));
		cdwClinic.setDisplayToPatientFlag(trimToEmpty(rs.getString(DISPLAY_APPT_TO_PATIENT_FLAG_COL)));

		return (cdwClinic);
	}
}
